VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmData 
   Caption         =   "wirt"
   ClientHeight    =   7020
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7905
   OleObjectBlob   =   "frmData.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "frmData"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

' Copyright (C) 2007 Stephane Germain <stephane.germain@gmail.com>
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or (at
' your option) any later version.
'
' This program is distributed in the hope that it will be useful, but
' WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
' General Public License for more details.
'
' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

Option Explicit
Option Base 0

Private Sub btnBack_Click()
    Me.Hide
    StepNum = StepNum - 1
    frmSelect.Show
End Sub

Private Sub btnCancel_Click()
    Me.Hide
End Sub

Private Sub btnHelp_Click()
    WirtHelp
End Sub

' count the number of value in a comma separated string
Public Function KeyLength(strKey As String) As Integer
    Dim i As Integer
    Dim NbrComma As Integer
    NbrComma = 0
    For i = 1 To Len(strKey)
        If Mid(strKey, i, 1) = "," Then NbrComma = NbrComma + 1
    Next i
    If Len(strKey) = 0 Then
        KeyLength = 0
    Else
        KeyLength = NbrComma + 1
    End If
End Function

' create a comma separated string from an array
Public Function KeyArrayToStr(Key() As String) As String
    Dim i As Integer
    KeyArrayToStr = Key(1)
    For i = 2 To UBound(Key)
        KeyArrayToStr = KeyArrayToStr & "," & Key(i)
    Next i
End Function

' create an array from a comma separated string
Public Function KeyStrToArray(strKey As String) As String()
    Dim i, CommaPos, NextComma, NbrKey As Integer
    Dim Key() As String
    NbrKey = KeyLength(strKey)
    ReDim Key(NbrKey) As String
    CommaPos = 0
    For i = 1 To UBound(Key) - 1
        NextComma = InStr(CommaPos + 1, strKey, ",")
        Key(i) = Mid(strKey, CommaPos + 1, NextComma - CommaPos - 1)
        CommaPos = NextComma
    Next i
    Key(UBound(Key)) = Mid(strKey, CommaPos + 1)
    KeyStrToArray = Key
End Function

Private Sub btnNext_Click()
    On Error GoTo errorEnd
    
    Binary = optBinary.Value
    MC = optMC.Value
    Graded = optGraded.Value
    SuccessString = cmbSuccess.Value
    MissingString = cmbMissing.Value
    
    ' validate the key
    If optMC.Value Then
        If KeyLength(txtKey.Text) <> NbrItem Then
            MsgBox GText("msgKeyLength"), vbApplicationModal, ProgName
            GoTo retryEnd
        End If
        Key = KeyStrToArray(txtKey.Text)
    ElseIf optBinary.Value Then
        Dim i As Integer
        For i = 1 To NbrItem
            Key(i) = SuccessString
        Next i
    End If
    
normalEnd:
    Me.Hide
    StepNum = StepNum + 1
    On Error GoTo 0
    frmModel.Show
    
retryEnd:
    Exit Sub

errorEnd:
    MsgBox GText("msgError", Err.Description), vbCritical, ProgName
End Sub

Private Sub optBinary_Click()
    lblSuccess.Enabled = True
    cmbSuccess.Enabled = True
    lblMissing.Enabled = True
    cmbMissing.Enabled = True
    lblKey.Enabled = False
    txtKey.Enabled = False
    lblKeyFeedback.Enabled = False
End Sub

Private Sub optGraded_Click()
    lblSuccess.Enabled = False
    cmbSuccess.Enabled = False
    lblMissing.Enabled = True
    cmbMissing.Enabled = True
    lblKey.Enabled = False
    txtKey.Enabled = False
    lblKeyFeedback.Enabled = False
End Sub

Private Sub optMC_Click()
    lblSuccess.Enabled = False
    cmbSuccess.Enabled = False
    lblMissing.Enabled = True
    cmbMissing.Enabled = True
    lblKey.Enabled = True
    txtKey.Enabled = True
    lblKeyFeedback.Enabled = True
End Sub

Private Sub txtKey_Change()
    lblKeyFeedback.Caption = GText("lblKeyFeedback", KeyLength(txtKey.Text))
End Sub

Private Sub UserForm_Activate()
    ReadSetting
    Me.Caption = ProgName
    ' get the localized string
    btnBack.Caption = GText("btnBack")
    btnNext.Caption = GText("btnNext")
    btnHelp.Caption = GText("btnHelp")
    btnCancel.Caption = GText("btnCancel")
    lblStep.Caption = GText("lblStep", StepNum, NbrStep)
    lblInstruction.Caption = GText("lblInstructionData")
    optBinary.Caption = GText("optBinary")
    optMC.Caption = GText("optMC")
    optGraded.Caption = GText("optGraded")
    lblSuccess.Caption = GText("lblSuccess")
    lblMissing.Caption = GText("lblMissing")
    lblKey.Caption = GText("lblKey")
    lblKeyFeedback.Caption = GText("lblKeyFeedback", KeyLength(txtKey.Text))
    optBinary.ControlTipText = GText("ttoptBinary")
    optMC.ControlTipText = GText("ttoptMC")
    optGraded.ControlTipText = GText("ttoptGraded")
    lblSuccess.ControlTipText = GText("ttlblSuccess")
    lblMissing.ControlTipText = GText("ttlblMissing")
    lblKey.ControlTipText = GText("ttlblKey")
    lblKeyFeedback.ControlTipText = GText("ttlblKeyFeedback")
    cmbSuccess.ControlTipText = GText("ttlblSuccess")
    cmbMissing.ControlTipText = GText("ttlblMissing")
    txtKey.ControlTipText = GText("ttlblKey")
    
    ' populate the key
    If HaveKey Then
        txtKey.Text = KeyArrayToStr(Key)
    End If
End Sub

Private Sub UserForm_Initialize()
    'populate the combo boxes
    cmbSuccess.AddItem "1"
    cmbSuccess.AddItem "TRUE"
    cmbSuccess.ListIndex = 0
    cmbMissing.AddItem ""
    cmbMissing.AddItem "NA"
    cmbMissing.AddItem "-1"
    cmbMissing.ListIndex = 0
End Sub

